// 初始化jsPDF
const { jsPDF } = window.jspdf;

// 定义常量
var splitVal = "^";

/**
 * 使用html2canvas 生成pdf
 * @returns
 */
function createPdf() {
  try {
    // 获取要转换的内容
    const pages = document.querySelectorAll(".container");
    const doc = new jsPDF("p", "mm", "a4");

    // 显示加载提示
    alert("正在生成PDF，请稍候...（转换过程可能需要几秒钟）");

    function renderPage(index) {
      if (index >= pages.length) {
        let pdfFileName = "国防专利密级证明" + new Date().getTime() + ".pdf";
        doc.save(pdfFileName);
        const dmyjTips = document.getElementById("dmyjTips");
        const bmydTips = document.getElementById("bmydTips");
        dmyjTips.style.display = "block";
        bmydTips.style.display = "block";
        return;
      }

      html2canvas(pages[index], {
        scale: 3,
        useCORS: true,
        logging: false,
      }).then((canvas) => {
        const imgData = canvas.toDataURL("image/jpeg", 1);
        const imgWidth = 210; // A4宽度（mm）
        const imgHeight = (canvas.height * imgWidth) / canvas.width;

        // 第一页不需要addPage
        if (index > 0) {
          doc.addPage();
        }

        doc.addImage(imgData, "JPEG", 0, 0, imgWidth, imgHeight);
        renderPage(index + 1);
      });
    }

    renderPage(0);
  } catch (error) {
    console.error(error);
    alert("生成PDF文件失败，异常信息：" + error.message);
  }
}

/**
 * 生成二维码
 * @params codeVal     二维码内容
 * @returns
 */
async function createQrCode(codeVal) {
  if (codeVal.length > 2) {
    try {
      await makeHighDensityQrCode("qrcode", codeVal);
      console.log("二维码内容：" + codeVal);
      // 生成pdf
      let intervalId = setInterval(() => {
        var qrcodeVal = document.getElementById("qrcode");
        if (qrcodeVal && qrcodeVal != "") {
          // 在生成pdf之前，将提示语去掉，保证生成的pdf中不带有提示语
          // 申请人2
          var sqrName2Val = document.getElementById("sqrName2");
          if (sqrName2Val.innerText == "") {
            sqrName2Val.setAttribute("data-placeholder", "");
          }
          // 申请人3
          var sqrName3Val = document.getElementById("sqrName3");
          if (sqrName3Val.innerText == "") {
            sqrName3Val.setAttribute("data-placeholder", "");
          }
          // 定密依据
          var dmyjVal = document.getElementById("dmyj");
          if (dmyjVal.innerText == "") {
            dmyjVal.setAttribute("data-placeholder", "");
          }
          // 定密要点
          var bmydVal = document.getElementById("bmyd");
          if (bmydVal.innerText == "") {
            bmydVal.setAttribute("data-placeholder", "");
          }
          // 生成pdf
          createPdf();
          clearInterval(intervalId);
        }
      }, 1000);
    } catch(e) {
      alert('二维码生成失败，请使用其他浏览器，推荐火狐或者奇安信浏览器');
    }
  }
}

 /**
 * 生成高密度二维码（通用实现）
 */
  async function makeHighDensityQrCode(key, content) {
    try {
      // 清空区域
      const container = document.getElementById(key);
      if (container) container.innerHTML = "";
      
      // 编码内容（通用处理）
      const encodedContent = await encodeForQr(content);
      // ====== 关键：为高密度内容调整参数 ======
      const qr = new QRCode(container, {
        width: 870,           // 增加尺寸 - 关键！
        height: 870,          // 增加尺寸 - 关键！
        margin: 6,             // 增加边距
        colorDark: "#000000",
        colorLight: "#ffffff",
        correctLevel: QRCode.CorrectLevel.Q, // 25%容错率 - 平衡点
        typeNumber: 40         // 最大版本
      });
      
      qr.makeCode(encodedContent);
      container.setAttribute("title", "");
      
    } catch (error) {
      throw error;
    }
  }

/**
 * 隐藏输入框的提示语
 */
function hidePlaceHolder() {
  const eles = document.querySelectorAll(".editable");
  eles.forEach((el) => {
    if (el.textContent === el.getAttribute("data-placeholder")) {
      el.textContent = "";
    }
  });
}
/**
 * 必填项校验
 */
function checkInputVal() {
  var tipMsg = "";
  // 校验发明名称
  var inventNameVal = document.getElementById("inventName").innerText;
  if (inventNameVal.trim() == "") {
    tipMsg += "请填写发明名称！<br/>";
  } else if (inventNameVal.length < 5 || inventNameVal.length > 60) {
    tipMsg += "发明名称不能少于5个汉字并且不能超过60个字！<br/>";
  }
  // 发明名称可公开
  var inventNamePublicChecked =
    document.getElementById("inventName_public").checked;
  const inventNamePublicVal = inventNamePublicChecked ? "0" : "1";
  // 校验申请人1
  var sqrName1Val = document.getElementById("sqrName1").innerText;
  if (sqrName1Val.trim() == "") {
    tipMsg += "请填申请人！<br/>";
  }
  // 申请人2
  var sqrName2Val = document.getElementById("sqrName2").innerText;
  // 申请人3
  var sqrName3Val = document.getElementById("sqrName3").innerText;
  // 申请人4
  var sqrName4Val = document.getElementById("sqrName4").innerText;
  // 申请人5
  var sqrName5Val = document.getElementById("sqrName5").innerText;
  // 校验第一署名申请人类型
  var sqrTypeVal = checkSqrType();
  if (sqrTypeVal === "100") {
    tipMsg += "第一署名申请人类型不能为空！<br/>";
  } else if (sqrTypeVal === "200") {
    tipMsg += "请选择第一署名申请人类型！<br/>";
  } else if (sqrTypeVal === "300") {
    tipMsg += "第一署名申请人类型不能输入逗号！<br/>";
  }
  // 校验第一署名申请人上级主管部门
  var sqrsjzgdwVal = document.getElementById("sqrsjzgdw").innerText;
  if (sqrsjzgdwVal == "") {
    tipMsg += "请填写第一署名申请人上级主管部门！<br/>";
  }
  // 校验申请人机要通信地址
  var sqrjytxdzVal = document.getElementById("sqrjytxdz").innerText;
  if (sqrjytxdzVal == "") {
    tipMsg += "请填写申请人机要通信地址！<br/>";
  }
  // 校验申请文件密级
  var sqwjMjVal = checkTwoRadioSelect("sqwjmj");
  if (sqwjMjVal === "100") {
    tipMsg += "请选择申请文件密级！<br/>";
  }
  // 校验保密期限\解密条件
  var fileBmqxVal = checkTwoRadioSelect("file_bmqx");
  if (fileBmqxVal === "100") {
    tipMsg += "请选择保密期限或解密条件！<br/>";
  }
  var bmTimeYearVal = document.getElementById("bmTimeYear").value;
  var bmTimeMonth = document.getElementById("bmTimeMonth").value;
  var jmtjVal = document.getElementById("jmtj").innerText;
  if (fileBmqxVal === "1" && bmTimeYearVal == "" && bmTimeMonth == "") {
    tipMsg += "请填写保密期限！<br/>";
  }
  if (fileBmqxVal === "2" && jmtjVal == "") {
    tipMsg += "请填写解密条件！<br/>";
  }
  if (fileBmqxVal === "1") {
    if (Number(bmTimeYearVal) < 0 || Number(bmTimeMonth) < 0) {
      tipMsg += "保密期限必须大于0！<br/>";
    }
    let totalMonth = Number(bmTimeYearVal) * 12 + Number(bmTimeMonth);
    // 保密期限，机密上限20年，秘密10年
    if (sqwjMjVal == 1 && totalMonth > 20 * 12) {
      tipMsg += "申请文件密级为机密时，保密期限不能超过20年！<br/>";
    } else if(sqwjMjVal == 2 && totalMonth > 10 * 12) {
      tipMsg += "申请文件密级为秘密时，保密期限不能超过10年！<br/>";
    }
  }
  // 定密依据
  var dmyjVal = document.getElementById("dmyj").innerText;
  // 定密要点
  var bmydVal = document.getElementById("bmyd").innerText;
  // 校验定密机关单位地址
  var dmjgjytxdzVal = document.getElementById("dmjgjytxdz").innerText;
  if (dmjgjytxdzVal == "") {
    tipMsg += "请填写定密机关、单位地址！<br/>";
  }
  // 校验定密机关单位联系人
  var dmjglxrVal = document.getElementById("dmjglxr").innerText;
  if (dmjglxrVal == "") {
    tipMsg += "请填写定密机关、单位联系人！<br/>";
  }
  // 校验电话
  var dmjglxrdhVal = document.getElementById("dmjglxrdh").value;
  if (dmjglxrdhVal == "") {
    tipMsg += "请填写定密机关、单位联系人电话！<br/>";
  } else {
    const result = validateMoble(dmjglxrdhVal);
    if (!result.valid) {
      tipMsg += result.msg;
    }
  }
  // 如果有提示内容，则弹出提示；否则生成二维码
  if (tipMsg != "") {
    document.getElementById("modalText").innerHTML = tipMsg;
    selfModelTip();
  } else {
    hidePlaceHolder();
    // 二维码内容+ dmyjVal + splitVal + bmydVal + splitVal
    inventNameVal = '';
    sqrName1Val = '';
    sqrName2Val = '';
    sqrName3Val = '';
    sqrName4Val = '';
    sqrName5Val = '';

    var qrcodeVal =
      splitVal +
      inventNameVal +
      splitVal +
      inventNamePublicVal +
      splitVal +
      sqrName1Val +
      splitVal +
      sqrName2Val +
      splitVal +
      sqrName3Val +
      splitVal +
      sqrName4Val +
      splitVal +
      sqrName5Val +
      splitVal +
      sqrTypeVal +
      splitVal +
      sqrsjzgdwVal +
      splitVal +
      sqrjytxdzVal +
      splitVal +
      sqwjMjVal +
      splitVal +
      fileBmqxVal +
      splitVal;
    if (fileBmqxVal == "1") {
      const months = Number(bmTimeYearVal) * 12 + Number(bmTimeMonth);
      qrcodeVal += months + splitVal;
    } else {
      qrcodeVal += jmtjVal + splitVal;
    }
    qrcodeVal +=
      dmyjVal +
      splitVal +
      bmydVal +
      splitVal +
      dmjgjytxdzVal +
      splitVal +
      dmjglxrVal +
      splitVal +
      dmjglxrdhVal;

    // 调用生成二维码接口
    console.log("总长度：" + qrcodeVal.length);
    // createQrCode(qrcodeVal1, qrcodeVal2, qrcodeVal3, qrcodeVal4);
    // 隐藏字数提示
    const dmyjTips = document.getElementById("dmyjTips");
    const bmydTips = document.getElementById("bmydTips");
    dmyjTips.style.display = "none";
    bmydTips.style.display = "none";
    const footerInventName = document.getElementById("footerInventName");
    const name = document.getElementById("inventName").innerText;
    footerInventName.innerText = name;
    // 对内容中的中文进行转码，由于扫描设备在识别中文时，部分无法识别

    createQrCode(qrcodeVal, "", "", "");
  }
}
/**
 * 校验发明名称
 */
function checkInventName() {
  // 校验发明名称
  var tipMsg = "";
  var inventNameVal = document.getElementById("inventName").innerText;
  if (inventNameVal.trim() == "") {
    tipMsg = "请填写发明名称！<br/>";
  } else if (inventNameVal.length < 5 || inventNameVal.length > 60) {
    tipMsg = "发明名称不能少于5个汉字并且不能超过60个字！<br/>";
  }
  if (tipMsg != "") {
    document.getElementById("modalText").innerHTML = tipMsg;
    selfModelTip();
  }
}
function validateMoble(val) {
  var regex =
    /^(?:(?:13[0-9]|14[579]|15[0-35-9]|16[6]|17[0-8]|18[0-9]|19[89])\d{8}|\+?86(?:13[0-9]|14[579]|15[0-35-9]|16[6]|17[0-8]|18[0-9]|19[89])\d{8}|(?:(?:[（(]\s*0\d{2,3}\s*[）)]|0\d{2,3})\s*[-]?\s*\d{7,8}))$/;
  const valid = regex.test(val.trim());
  let msg = "";
  if (!valid) {
    msg =
      "请输入正确的电话号码！<br/>如：13812345678<br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;+8613812345678<br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;010-12345678<br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;(010)12345678";
  }
  return {
    valid,
    msg,
  };
}
/**
 * 校验电话号码
 */
function checkMobile() {
  var dmjglxrdhVal = document.getElementById("dmjglxrdh").value;
  const result = validateMoble(dmjglxrdhVal);
  if (!result.valid) {
    document.getElementById("modalText").innerHTML = result.msg;
    selfModelTip();
  }
}

/**
 * 检验申请人类型是否选中
 * @returns
 */
function checkSqrType() {
  var radioButtons = document.getElementsByName("sqrType");
  // 检查是否有单选按钮被选中
  var selectedValue = null;
  for (var i = 0; i < radioButtons.length; i++) {
    if (radioButtons[i].checked) {
      selectedValue = radioButtons[i].value;
      break;
    }
  }
  // 如果选择了自定义选项，检查自定义输入框是否为空
  if (selectedValue === "4") {
    var selfInput = document
      .getElementById("sqrType_self_txt")
      .innerText.trim();
    if (selfInput === "") {
      return "100";
    } else if (/[,，]/.test(selfInput)) {
      return "300";
    } else {
      selectedValue = "4," + selfInput;
    }
  } else {
    document.getElementById("sqrType_self_txt").innerText = "";
  }

  // 如果没有选中任何单选按钮
  if (selectedValue === null) {
    return "200";
  } else {
    return selectedValue;
  }
}
/**
 * 校验申请文件密级
 * @returns
 */
function checkTwoRadioSelect(radioName) {
  // 获取所有申请文件密级的单选按钮
  var confidentialityLevelRadios = document.getElementsByName(radioName);

  // 检查是否有单选按钮被选中
  var selectedValue = null;
  for (var i = 0; i < confidentialityLevelRadios.length; i++) {
    if (confidentialityLevelRadios[i].checked) {
      selectedValue = confidentialityLevelRadios[i].value;
      break;
    }
  }

  // 如果没有选中任何单选按钮
  if (selectedValue === null) {
    return "100";
  } else {
    return selectedValue;
  }
}

/**
 * 自定义弹出提示框
 */
function selfModelTip() {
  // Show the modal
  document.getElementById("modal").style.display = "block";

  // Get the <span> element that closes the modal
  var span = document.getElementsByClassName("close")[0];

  // When the user clicks on <span> (x), close the modal
  span.onclick = function () {
    document.getElementById("modal").style.display = "none";
  };

  // When the user clicks anywhere outside of the modal, close it
  window.onclick = function (event) {
    var modal = document.getElementById("modal");
    if (event.target == modal) {
      modal.style.display = "none";
    }
  };
}
/**
 * 处理发明名称是否公开，0代表不勾选；1代表选中
 * @param {} obj
 */
function setFmmcOpenVal(obj) {
  var initVal = obj.value;
  if (initVal === "0") {
    obj.setAttribute("value", "1");
  } else {
    obj.setAttribute("value", "0");
  }
}

/**
 * 通用GBK编码函数
 */
function encodeForQr(content) {
  return new Promise((resolve, reject) => {
    // 仅当内容包含中文时使用GBK编码
    if (/[\u4e00-\u9fa5]/.test(content)) {
      createGbkEncodingIframe(content)
        .then(encoded => resolve(`GBK:${encoded}`))
        .catch(reject);
    } else {
      resolve(content);
    }
  });
}

/**
 * 创建GBK编码iframe
 */
function createGbkEncodingIframe(content) {
  return new Promise((resolve, reject) => {
    const iframe = document.createElement('iframe');
    iframe.style.display = 'none';
    document.body.appendChild(iframe);
    
    let cleanupDone = false;
    
    const cleanup = () => {
      if (!cleanupDone) {
        cleanupDone = true;
        setTimeout(() => {
          try {
            if (iframe && iframe.parentNode) {
              iframe.parentNode.removeChild(iframe);
            }
          } catch (e) {
            console.error("清理iframe失败", e);
          }
        }, 500);
      }
    };
    
    iframe.onload = function() {
      try {
        const doc = iframe.contentDocument || (iframe.contentWindow && iframe.contentWindow.document);
        if (!doc) {
          console.error("iframe 文档对象不可用");
          throw new Error("iframe 文档对象不可用");
        }
        doc.open();
        doc.charset = 'GBK';
        doc.write(`
          <!DOCTYPE html>
          <html>
            <head>
              <meta charset="GBK">
            </head>
            <body>${content}</body>
          </html>
        `);
        doc.close();
      } catch (e) {
        reject(e);
        cleanup();
      }
    };
    
    iframe.addEventListener('load', function() {
      const check = () => {
        try {
          const doc = iframe.contentDocument || (iframe.contentWindow && iframe.contentWindow.document);
          if (!doc) {
            console.error("iframe 文档对象不可用");
            throw new Error("iframe 文档对象不可用");
          }
          const bodyText = doc.body.innerText;
          if (bodyText) {
            cleanup();
            resolve(encodeURIComponent(bodyText));
          } else {
            setTimeout(check, 20);
          }
        } catch (e) {
          reject(e);
          cleanup();
        }
      };
      
      setTimeout(check, 30);
    });
    
    iframe.src = 'about:blank';
    
    // 超时处理
    setTimeout(() => {
      if (!cleanupDone) {
        reject(new Error('GBK编码超时'));
        cleanup();
      }
    }, 2000);
  });
}

