$(document).ready(function () {
  const eles = document.querySelectorAll(".editable");
  eles.forEach((el) => {
    el.addEventListener("focus", function () {
      if (this.textContent === this.getAttribute("data-placeholder")) {
        this.textContent = "";
      }
    });
  });
  const el = $('input[name="file_bmqx"]');
  el.change(function () {
    const val = $(this).val();
    if (val == 1) {
      $("#bmqx_div").show();
      $("#jmtj").hide();
    } else if (val == 2) {
      $("#bmqx_div").hide();
      $("#jmtj").show();
    }
  });
});

document.addEventListener('DOMContentLoaded', function() {
  // 加载缓存数据
  loadFormData();

  // 监听表单输入事件
  document.querySelectorAll('.editable').forEach(function(input) {
      input.addEventListener('input', saveFormData);
  });

  document.querySelector('#dataForm form').addEventListener('change', saveFormData);
  // 限制字数的字段集合
  const limitFields = [
    {
      name: 'inventName',
      maxLength: 60
    },
    {
      name: 'sqrName1',
      maxLength: 30
    },
    {
      name: 'sqrName2',
      maxLength: 30
    },
    {
      name: 'sqrName3',
      maxLength: 30
    },
    {
      name: 'sqrName4',
      maxLength: 30
    },
    {
      name: 'sqrName5',
      maxLength: 30
    },
    {
      name: 'sqrType_self_txt',
      maxLength: 30
    },
    {
      name: 'sqrsjzgdw',
      maxLength: 30
    },
    {
      name: 'sqrjytxdz',
      maxLength: 40
    },
    {
      name: 'jmtj',
      maxLength: 20
    },
    {
      name: 'dmjgjytxdz',
      maxLength: 40
    },
    {
      name: 'dmjglxr',
      maxLength: 40
    },
    {
      name: 'dmyj',
      maxLength: 60,
      charCountId: 'dmyjCharCount'
    },
    {
      name: 'bmyd',
      maxLength: 60,
      charCountId: 'bmydCharCount'
    },
  ]
  limitFields.forEach(function(item) {
    limitWordLength(item.name, item.maxLength, item.charCountId);
  })
});
/**
 * 保存缓存
 */
function saveFormData() {
  const formData = {};
  document.querySelectorAll('.editable, input, select, textarea').forEach(function(input) {
      // 如果是可公开、第一署名申请人类型、申请文件密级、保密期限等内容，则不进行缓存
      if (input.id =='inventName_public' || 
          input.id.indexOf('sqrType_') > 0 || 
          input.id.indexOf('sqwj_') > 0 || 
          input.id.indexOf('file_') > 0 || 
          input.id =='bmTimeYear' || 
          input.id =='bmTimeMonth' || 
          input.id =='jmtj') {        
        console.log("1:" + input.id + ", 2: " + input.textContent + ", 3:" + input.value);
      } else {
        formData[input.id] = input.textContent || input.value;
      }
      
    });
  localStorage.setItem('formData', JSON.stringify(formData));
}
/**
 * 加载缓存
 */
function loadFormData() {
  const formData = JSON.parse(localStorage.getItem('formData')) || {};
  Object.keys(formData).forEach(function(key) {
    const element = document.getElementById(key);
    if (element) {
          if (element.contentEditable === 'true') {
        element.textContent = formData[key];
      } else {
        element.value = formData[key];
      }
    }
  });
}
/**
 * 清空缓存
 */
function clearFormData() {
  localStorage.removeItem('formData');
  // 将电话清空
  document.getElementById("dmjglxrdh").innerHTML = '';
  location.reload();
}

function limitWordLength(contentDivId, maxLength, charCountId) {
  const div = document.getElementById(contentDivId);
  // 初始化时更新计数
  if (charCountId) {
    updateCharCount(charCountId);
  }

  // 键盘按键事件 - 阻止超过长度的输入
  div.addEventListener("keydown", function (event) {
    // 检查是否按下了回车键（现代浏览器推荐使用event.key）
    if (event.key === 'Enter' || event.keyCode === 13) {
      // 阻止默认行为（即换行）
      event.preventDefault();
    }
    // 阻止Shift+Enter（某些浏览器中会产生<br>）
    if (event.shiftKey && (event.key === 'Enter' || event.keyCode === 13)) {
      event.preventDefault();
      return false;
    }
    const currentText = getVisibleText(this);

    // 如果已达到最大长度且用户尝试输入新字符
    if (currentText.length >= maxLength && !isControlKey(event)) {
      event.preventDefault();
    }
  });

  // 输入事件 - 确保内容不会超过限制
  div.addEventListener("input", function () {
    let currentText = getVisibleText(this);

    if (currentText.length > maxLength) {
      // 截断为最大长度
      this.textContent = currentText.substring(0, maxLength);
      // 保持光标在末尾
      placeCaretAtEnd(this);
    }

    if (charCountId) {
      updateCharCount(charCountId);
    }
  });

  // 粘贴事件 - 处理粘贴操作
  div.addEventListener("paste", function (event) {
    const currentText = getVisibleText(this);

    // 阻止默认粘贴行为
    event.preventDefault();
    // 从剪贴板获取纯文本
    let pastedText = '';
    if (event.clipboardData && event.clipboardData.getData) {
      pastedText = event.clipboardData.getData('text/plain');
    } else if (window.clipboardData && window.clipboardData.getData) {
      // 兼容IE
      pastedText = window.clipboardData.getData('Text');
    }
    // 移除所有换行符，替换为空格（保持单词可读性）
    pastedText = pastedText.replace(/[\r\n]+/g, ' ');
    // 计算可以粘贴的字符数
    const remainingChars = maxLength - currentText.length;
    const textToInsert =
      remainingChars > 0 ? pastedText.substring(0, remainingChars) : "";
    // 插入内容
    document.execCommand("insertText", false, textToInsert);
  });

  // 获取可见文本（去除HTML标签）
  function getVisibleText(element) {
    return element.textContent || element.innerText || "";
  }

  // 判断是否是控制键（允许使用方向键、删除键等）
  function isControlKey(event) {
    return (
      event.ctrlKey ||
      event.metaKey ||
      event.key === "Backspace" ||
      event.key === "Delete" ||
      event.key === "ArrowLeft" ||
      event.key === "ArrowRight" ||
      event.key === "ArrowUp" ||
      event.key === "ArrowDown" ||
      (event.key === "a" && (event.ctrlKey || event.metaKey)) || // Ctrl+A
      (event.key === "c" && (event.ctrlKey || event.metaKey)) || // Ctrl+C
      (event.key === "v" && (event.ctrlKey || event.metaKey)) || // Ctrl+V
      (event.key === "x" && (event.ctrlKey || event.metaKey))
    ); // Ctrl+X
  }

  // 将光标定位到内容末尾
  function placeCaretAtEnd(element) {
    element.focus();
    if (window.getSelection) {
      const range = document.createRange();
      range.selectNodeContents(element);
      range.collapse(false);
      const sel = window.getSelection();
      sel.removeAllRanges();
      sel.addRange(range);
    }
  }

  // 更新字符计数
  function updateCharCount(charCountId) {
    const charCount = document.getElementById(charCountId);
    const currentText = getVisibleText(div);
    charCount.textContent = currentText.length;

    // 当接近最大长度时改变颜色提示
    if (currentText.length > maxLength * 0.8) {
      charCount.style.color = "orange";
    } else {
      charCount.style.color = "#666";
    }

    if (currentText.length >= maxLength) {
      charCount.style.color = "red";
    }
  }
}
